/*******************************************************}
{                                                       }
{               Borland DB Web                          }
{           Data aware Web controls                     }
{  Copyright (c) 2003 Borland Software Corporation      }
{                                                       }
{*******************************************************/

using System;
using System.Data;
using System.Data.Common;
using System.IO;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.ComponentModel;
using System.Collections;
using System.ComponentModel.Design;
using System.Web.UI.Design;

namespace Borland.Data.Web
{

   #region DBWebDataSourceDesigner
   public class DBWebDataSourceDesigner: ComponentDesigner
   {
   	public DBWebDataSourceDesigner(): base()
      {
      }
      protected override void PreFilterProperties(System.Collections.IDictionary properties)
      {
      	base.PreFilterProperties(properties);
      	if( properties.Contains("RelatedTables") )
      		properties.Remove("RelatedTables");
      }
   }

   #endregion

   #region DBWebControlDesigners

   #region IDBWebControlDesigner;

   public enum eRemoveBindingType
   {
   	erbtColumnsOnly,
      erbtTablesAndColumns,
      erbtLookupColumnsOnly,
      erbtAll
   }

   public interface IDBWebControlDesigner
   {
      void PreFilterProperties(System.Collections.IDictionary properties, IDBWebDataLink control);
      void RemoveBindings(IDBWebDataLink webControl, eRemoveBindingType removeType);
      bool OnComponentRemoving(IDBWebDataLink webControl, ComponentEventArgs e);
		void SetProperties(DataBindingCollection DataBindings,
      			IDBWebDataLink webControl, ComponentCollection Components);
      string FindCompForNewValue(object sender, UpdateComponentEventArgs ce);
      string FindCompForTableName(object sender, UpdateComponentEventArgs ce);
      string FindCompForColumnName(object sender, UpdateComponentEventArgs ce);
		void UpdateComp(ComponentChangedEventArgs ce, ComponentCollection Components,
						string propertyName, Type propType, DataBindingCollection DataBindings);
      void UpdateWebControl(IDBWebDataLink webControl, ComponentCollection Components,
      				ComponentChangedEventArgs ce, DataBindingCollection DataBindings);
      bool UpdateParentControl(IDBWebDataLink webControl, ComponentChangedEventArgs ce);
   }
   #endregion
   #region DBWebDesigner
   public class DBWebDesigner : IDBWebControlDesigner
   {
   	protected event OnComponentChangedEvent OnUpdateComp;

      string IDBWebControlDesigner.FindCompForNewValue(object sender, UpdateComponentEventArgs ce)
      {
      	if( ce.Component == ce.Object && ce.Object != null )
         	return ce.Component.Site.Name;
         return "";
      }

      bool IDBWebControlDesigner.UpdateParentControl(IDBWebDataLink webControl, ComponentChangedEventArgs ce)
      {
      	Object o = DU.GetPropertyValue( webControl, "DBDataSource" );
      	if( o != null && o is DBWebDataSource )
         {
         	DBWebDataSource ds = o as DBWebDataSource;
            // if DataSource properties have been changed
            if( ds == ce.Component || ds.DataSource == ce.Component )
            {
               string propertyName = ce.Member.Name;
               if( propertyName == "Name" && ds == ce.Component )
               {
               	object TableName = DU.GetPropertyValue(webControl, "TableName" );
                  DU.SetPropertyValue(webControl, "DBDataSource", ce.Component );
                  if( TableName != null )
                  {
                  	DU.SetPropertyValue(webControl, "TableName", TableName);
                  }
               }
               else
               	return true;
            }
            else if (ce.Component is DataView )
            {
               DataView dv = ce.Component as DataView;
            	if( ds.DataSource != null && ds.DataSource == dv )
               	return true;
            }
            else if (ce.Component is DataTable )
            {
               DataTable tbl = ce.Component as DataTable;
               if( ds.DataSource != null )
               {
                  if( ds.DataSource == tbl )
                  {
                  	DU.SetPropertyValue(webControl, "TableName", tbl.TableName);
               		return true;
                  }
               	else if( ds.DataSource == tbl.DataSet )
                  {
                  	if( ds.DataSource is DataSet && !ClassUtils.IsEmpty(webControl.TableName) )
                     {
                     	DataSet dataSet = ds.DataSource as DataSet;
                        if( !ClassUtils.IsEmpty(Convert.ToString(ce.OldValue)) && webControl.TableName == Convert.ToString(ce.OldValue) )
                  			DU.SetPropertyValue(webControl, "TableName", tbl.TableName);
                     }
               		return true;
                  }
               }
            }
            else if( ce.Component is DataAdapter )
            {
               DataAdapter adapter = ce.Component as DataAdapter;
            	DataSet DaDs = DU.GetPropertyValue(adapter, "DataSet") as DataSet;
               if( DaDs != null && ds.DataSource != null && DaDs == ds.DataSource )
               {
                  return true;
               }
            }
         }
         return false;
      }


      void IDBWebControlDesigner.UpdateWebControl(IDBWebDataLink webControl,
      				ComponentCollection Components, ComponentChangedEventArgs ce,
                  DataBindingCollection DataBindings)
      {
      	string propertyName = ce.Member.Name;
      	if( propertyName == "DBDataSource" || propertyName == "TableName" || propertyName == "ColumnName" ||
         		propertyName == "LookupTableName" || propertyName == "DataTextField" ||
               propertyName == "DataValueField" )
         {
         	Type propType;
            propType = typeof(IEnumerable);
            if( propertyName == "DBDataSource" )
            	OnUpdateComp += new OnComponentChangedEvent((this as IDBWebControlDesigner).FindCompForNewValue);
            else if( propertyName == "TableName" || propertyName == "LookupTableName")
            	OnUpdateComp += new OnComponentChangedEvent((this as IDBWebControlDesigner).FindCompForTableName);
            else if( propertyName == "ColumnName" || propertyName == "DataTextField" ||
            	propertyName == "DataValueField" )
               OnUpdateComp += new OnComponentChangedEvent((this as IDBWebControlDesigner).FindCompForColumnName);
            (this as IDBWebControlDesigner).UpdateComp(ce, Components, propertyName, propType, DataBindings);
            if( ce.NewValue == null || ce.NewValue.ToString() == "" )
            {
               if( propertyName == "DBDataSource" )
            		(this as IDBWebControlDesigner).RemoveBindings(webControl, eRemoveBindingType.erbtAll);
            	if( propertyName == "TableName" )
            		(this as IDBWebControlDesigner).RemoveBindings(webControl, eRemoveBindingType.erbtTablesAndColumns);
               else
               {
                  if( propertyName == "LookupTableName" )
            			(this as IDBWebControlDesigner).RemoveBindings(webControl, eRemoveBindingType.erbtLookupColumnsOnly);
               // no need to remove bindings for "ColumnName", "DataValueField", or "DataTextField"
               }
            }
            else if( propertyName == "TableName" && ce.NewValue != null &&
                     !ClassUtils.SameValue(Convert.ToString(ce.OldValue), Convert.ToString(ce.NewValue) ) )
					(this as IDBWebControlDesigner).RemoveBindings(webControl, eRemoveBindingType.erbtColumnsOnly);
            else if( propertyName == "LookupTableName" &&
                     !ClassUtils.SameValue(Convert.ToString(ce.OldValue), Convert.ToString(ce.NewValue) ) )
					(this as IDBWebControlDesigner).RemoveBindings(webControl, eRemoveBindingType.erbtLookupColumnsOnly);
            else if( (propertyName == "ColumnName") && (webControl != null) && (webControl is DBWebLabeledTextBox) )
            {
            	string caption = (webControl as DBWebLabeledTextBox).Caption;
            	if( ClassUtils.IsEmpty(caption) || (ce.OldValue != null && Convert.ToString(ce.OldValue) == caption ) )
               {
               	if( ce.NewValue == null )
            			DU.SetPropertyValue(webControl, "Caption", null );
                  else
            			DU.SetPropertyValue(webControl, "Caption", Convert.ToString(ce.NewValue) );
               }
            }
      	}
      }


      string IDBWebControlDesigner.FindCompForTableName(object sender, UpdateComponentEventArgs ce)
      {
      	if( ce.Component is DataTable && ce.Object != null )
         	if((ce.Component as DataTable).TableName == ce.Object.ToString())
         		return ce.Object.ToString();
         return "";
      }
      string IDBWebControlDesigner.FindCompForColumnName(object sender, UpdateComponentEventArgs ce)
      {

      	if ( ce.Component is DataColumn && ce.Object != null )
         	if ((ce.Component as DataColumn).ColumnName == ce.Object.ToString())
            	return ce.Object.ToString();
         return "";
      }

      void IDBWebControlDesigner.PreFilterProperties(System.Collections.IDictionary properties, IDBWebDataLink control)
		{
      	if( properties.Contains("DataBindings") )
      		properties.Remove("DataBindings");
      	if( properties.Contains("DataMember") )
      		properties.Remove("DataMember");
      	if( properties.Contains("DataKeyField") )
      		properties.Remove("DataKeyField");
         if( properties.Contains("ImageUrl") )
         	properties.Remove("ImageUrl");
         if( properties.Contains("SelectedDate") )
         	properties.Remove("SelectedDate");
         if( properties.Contains("VisibleDate") )
         	properties.Remove("VisibleDate");
         if( control is IDBWebLookupColumnLink )
         	if( properties.Contains("Items") )
            	properties.Remove("Items");
         if( control is DBWebCheckBox )
         	if( properties.Contains("Checked") )
            	properties.Remove("Checked");
      }
      void IDBWebControlDesigner.RemoveBindings(IDBWebDataLink webControl, eRemoveBindingType removeType)
		{
      	if( removeType == eRemoveBindingType.erbtAll )
      		DU.SetPropertyValue(webControl, "DBDataSource", null);
      	if( removeType != eRemoveBindingType.erbtColumnsOnly && removeType != eRemoveBindingType.erbtLookupColumnsOnly )
     			DU.SetPropertyValue(webControl, "TableName", null);
         if( webControl is IDBWebColumnLink && removeType != eRemoveBindingType.erbtLookupColumnsOnly )
         	DU.SetPropertyValue(webControl as IDBWebColumnLink, "ColumnName", null);
      	if( removeType != eRemoveBindingType.erbtColumnsOnly && webControl is IDBWebLookupColumnLink )
         {
         	IDBWebLookupColumnLink lupControl = (webControl as IDBWebLookupColumnLink);
            try
            {
            DU.SetPropertyValue(lupControl, "DataValueField", null );
            DU.SetPropertyValue(lupControl, "DataTextField", null );
            if( removeType != eRemoveBindingType.erbtLookupColumnsOnly )
            	DU.SetPropertyValue(lupControl, "LookupTableName", null );
            }
            catch
            {  // Ignore 
            }
         }
      }
      bool IDBWebControlDesigner.OnComponentRemoving(IDBWebDataLink webControl, ComponentEventArgs e)
		{
         bool retVal = false;
      	if( webControl != null && webControl.DBDataSource != null )
         {
            retVal = true;
         	if( e.Component == webControl.DBDataSource )
	         	(this as IDBWebControlDesigner).RemoveBindings(webControl, eRemoveBindingType.erbtAll);
            else if( webControl.DBDataSource.GetDataSource(null) != null )
            {
               Object DsDs = webControl.DBDataSource.GetDataSource(null);
               if( DsDs == e.Component )
            	{
                  DU.SetPropertyValue(webControl.DBDataSource, "DataSource", null);
            		(this as IDBWebControlDesigner).RemoveBindings(webControl, eRemoveBindingType.erbtTablesAndColumns);
            	}
               else if( e.Component is DataAdapter )
               {
                  try
                  {
	               	DataSet AdDs = DU.GetPropertyValue(e.Component, "DataSet") as DataSet;
   	               if( AdDs != null && AdDs == DsDs )
                     {
                     	DU.SetPropertyValue(webControl.DBDataSource, "DataSource", null );
      	      			(this as IDBWebControlDesigner).RemoveBindings(webControl, eRemoveBindingType.erbtTablesAndColumns);
                     }
                  }
                  catch
                  {
               		// ignore exceptions, as might occur if there is no "DataSet" property
                  }
               }
               else if( e.Component is DataView )
               {
               	DataTable table = (e.Component as DataView).Table;
                  if( (table != null) && (table.DataSet != null) )
                  	if( table.DataSet == DsDs && e.Component == DsDs )
                     {
                     	DU.SetPropertyValue(webControl.DBDataSource, "DataSource", null );
            				(this as IDBWebControlDesigner).RemoveBindings(webControl, eRemoveBindingType.erbtTablesAndColumns);
                     }
               }
            }
         }
         return retVal;
      }
      
		void IDBWebControlDesigner.SetProperties(DataBindingCollection DataBindings,
      					IDBWebDataLink webControl, ComponentCollection Components)
		{
         if( webControl == null )
         	return;
			DataBinding binding = DataBindings["DBDataSource"];
         if( webControl.DBDataSource == null && binding != null )
         {
	      	foreach( System.ComponentModel.IComponent comp in Components )
   	      {
      	   	if( comp.Site.Name == binding.Expression )
         	   {
            		webControl.DBDataSource = comp.Site.Component as DBWebDataSource;
               	break;
	            }
   	      }
         }
         else
         {
				binding = DataBindings["TableName"];
   	      if( ClassUtils.IsEmpty(webControl.TableName) && binding != null )
      	   	webControl.TableName = binding.Expression;
         }
         if( webControl is IDBWebColumnLink )
         {
         	IDBWebColumnLink colControl = (webControl as IDBWebColumnLink);
				binding = DataBindings["ColumnName"];
   	      if( ClassUtils.IsEmpty(colControl.ColumnName) && binding != null )
      	   	colControl.ColumnName = binding.Expression;
         }
         if( webControl is IDBWebLookupColumnLink && webControl.DBDataSource != null )
         {
         	IDBWebLookupColumnLink lookupControl = (webControl as IDBWebLookupColumnLink);
				binding = DataBindings["LookupTableName"];
   	      if( ClassUtils.IsEmpty(lookupControl.LookupTableName) && binding != null )
      	   	lookupControl.LookupTableName = binding.Expression;
            if( !ClassUtils.IsEmpty(lookupControl.LookupTableName) )
            {
					binding = DataBindings["DataTextField"];
   		      if( ClassUtils.IsEmpty(lookupControl.DataTextField) && binding != null )
      		   	lookupControl.DataTextField = binding.Expression;
					binding = DataBindings["DataValueField"];
   	      	if( ClassUtils.IsEmpty(lookupControl.DataValueField) && binding != null )
      	   		lookupControl.DataValueField = binding.Expression;
            }
         }
         if( webControl is DBWebCheckBox )
         {
         	DBWebCheckBox cb = webControl as DBWebCheckBox;
         	if( webControl.DBDataSource == null && ClassUtils.IsEmpty(cb.Text) )
            	cb.Text = cb.ID;
         }
         if( webControl is WebControl )
         	(webControl as WebControl).DataBind();
      }

		void IDBWebControlDesigner.UpdateComp(ComponentChangedEventArgs ce, ComponentCollection Components,
						string propertyName, Type propType, DataBindingCollection DataBindings)
		{
      	UpdateComponentEventArgs cee = null;
      	DataBindings.Remove(propertyName);
         object o = null;
         string propVal = "";
         if( ce.Component != null && ce.NewValue != null )
         {
	         foreach( System.ComponentModel.IComponent comp in Components )
				{
      	   	cee = new UpdateComponentEventArgs(comp, ce.NewValue);
         	   propVal = OnUpdateComp(this, cee);
            	o = comp;
	            if( propVal != "") break;
   	      }
      	   if( propVal != "" )
         	{
         		try
	            {
   	         	if( DataBindings[propertyName] == null )
      	         {
         	      	DataBinding binding = new DataBinding(propertyName, propType, propVal);
            	      DataBindings.Add(binding);
               	}
	            }
   	         catch( Exception e)
      	      {
         	   	throw new Exception(propVal + " - " + e.Message);
            	}
	         }
         }
      }
   }
   #endregion

   #region DBWebControlDesigner
   public class DBWebControlDesigner: System.Web.UI.Design.ControlDesigner
   {
   	protected event OnComponentChangedEvent OnUpdateComp;
		protected static bool InDesignerChange;
      protected IDBWebControlDesigner FDBWebControlDesigner;

   	private IDBWebDataLink webControl;
      protected IComponentChangeService componentChangeService;
      private ComponentEventHandler componentRemovedHandler;
      private ComponentChangedEventHandler componentChangedHandler;
   	public DBWebControlDesigner(): base()
      {
         FDBWebControlDesigner = new DBWebDesigner();
      }

      protected override void PreFilterProperties(System.Collections.IDictionary properties)
      {
      	base.PreFilterProperties(properties);
         FDBWebControlDesigner.PreFilterProperties(properties, Component as IDBWebDataLink);
      	if( properties.Contains("DataSource") )
      		properties.Remove("DataSource");
         if( Component is DBWebMemo )
         	if( properties.Contains("TextMode") )
            	properties.Remove("TextMode");
         if( !(Component is DBWebCheckBox) )
         	if( properties.Contains("Text") )
         		properties.Remove("Text");
      }

      public override void Initialize(IComponent component)
      {
         base.Initialize(component);
         componentChangeService = (IComponentChangeService)GetService(typeof(IComponentChangeService));
         if ((componentChangeService != null))
	            {
                componentRemovedHandler = new System.ComponentModel.Design.ComponentEventHandler(OnComponentRemoving);
                componentChangeService.ComponentRemoved += componentRemovedHandler;
                componentChangedHandler = new System.ComponentModel.Design.ComponentChangedEventHandler(OnComponentChanged);
                componentChangeService.ComponentChanged += componentChangedHandler;
            }
         if( component is IDBWebDataLink )
         	webControl = (IDBWebDataLink) component;
         return;
      }

      protected override void Dispose(bool disposing)
      {
      	if (disposing && componentRemovedHandler != null && componentChangeService != null)
         {
         	componentChangeService.ComponentRemoved -= componentRemovedHandler;
            componentRemovedHandler = null;
            componentChangeService.ComponentChanged -= componentChangedHandler;
            componentChangedHandler = null;
            componentChangeService = null;
         }
         base.Dispose(disposing);
      }

		public override bool DesignTimeHtmlRequiresLoadComplete
		{
			get
			{
				return true;
			}
		}

      private void RemoveBindings(bool bSetDSNull)
      {
      	FDBWebControlDesigner.RemoveBindings(webControl, eRemoveBindingType.erbtAll);
      }

      private void OnComponentRemoving(object sender, ComponentEventArgs e)
      {
      	webControl = Component as IDBWebDataLink;
         FDBWebControlDesigner.OnComponentRemoving(webControl, e);
      }

      // this code targets the Borland RAD IDE.  In any other
      // products null will be returned, and no attempt will be
      // make to create a virtual directory BorlandImages
      private string FindTemplatePath(string sFileToFind)
      {
      	const string sBin = "\\bin";
         const string sApp = "\\app";
         const string sTemplate = "\\template\\images\\";
         const string sObjRepos = "\\objrepos\\images\\";
         string binDir = System.AppDomain.CurrentDomain.BaseDirectory.ToLower();
         int i = binDir.IndexOf(sBin);
         if( i <= 0 )
         	i = binDir.IndexOf(sApp);
         if( i > 0 )
         {
         	binDir = binDir.Substring(0, i);
            if( File.Exists( binDir + sObjRepos + sFileToFind ) )
					return binDir + sObjRepos;
            if( File.Exists( binDir + sTemplate + sFileToFind ) )
					return binDir + sTemplate;
         }
         return null;
      }

      protected void CheckForVirtualDirectory(DBWebNavigator nav)
      {
      	try
         {
         	if( nav.ImagesVirtualPath == (nav as INavigatorDesignAccess).GetDefaultImagesVirtualPath() )
            {
            	VirtualDirectory vDir = new VirtualDirectory("");
               if( ClassUtils.IsEmpty(vDir.FindPathForVirtualDir(nav.ImagesVirtualPath) ) )
               {  // if default VirtualDirectory does not exist, create it.
               	string TemplatePath = FindTemplatePath((nav as INavigatorDesignAccess).GetButtonFileName());
                  if( !ClassUtils.IsEmpty(TemplatePath) )
                  	vDir.CreateVirtualDir(nav.ImagesVirtualPath, TemplatePath);
               }
            }
         }
         catch
         {
         	// ignore any errors: if Adsi access is not allowed, we simply fail
         }
      }
      protected void SetCheckBoxProperties(ComponentChangedEventArgs ce, IDBWebDataLink webControl)
   	{
      	if( ce.Member != null )
         {
         	DBWebCheckBox cb = webControl as DBWebCheckBox;
            // if Text property has been set by user, designer will not set it.
            if( !ClassUtils.IsEmpty(cb.Text) && cb.Text != cb.ID)
            	if( ce.OldValue == null || (Convert.ToString(ce.OldValue) != cb.Text) )
            		return;
            string colName;
            if(ce.NewValue != null)
            	colName  = Convert.ToString(ce.NewValue);
            else
            	colName = null;
            if( ce.Member.Name == "ColumnName" && !ClassUtils.IsEmpty(colName) )
            	DU.SetPropertyValue(cb, "Text", colName);
            else
            	DU.SetPropertyValue(cb, "Text", cb.ID);
         }
      }

      // DataProvider and DataSet changes might trigger changes in DBWebControls
      protected void CheckForUpdate(ComponentChangedEventArgs ce, IDBWebDataLink webControl)
      {
      	object changedComponent = ce.Component;
      	if( FDBWebControlDesigner.UpdateParentControl( webControl, ce ) )
         	UpdateDesignTimeHtml();
         if( changedComponent is DataAdapter && ce.Member != null )
         {
         	if( ce.Member.Name == "Active" && Convert.ToBoolean(ce.NewValue) == false )
            	UpdateDesignTimeHtml();
            else if( ce.Member.Name == "SelectCommand" )
            	UpdateDesignTimeHtml();
         }
         if( (changedComponent is DataSet || changedComponent is DataView) && webControl.DBDataSource != null )
         {
         	object o = webControl.DBDataSource.GetDataSource(null);
            if( o != null )
            {
            	if( o == changedComponent )
               	UpdateDesignTimeHtml();
               else if( changedComponent is DataSet )
               {
               	for( int i = 0; i < (changedComponent as DataSet).Tables.Count; i++ )
                  {
                  	if( (changedComponent as DataSet).Tables[i] == o )
                     {
                     	UpdateDesignTimeHtml();
                        break;
                     }
                  }
               }
            }
         }
      }

      // Important that each time OnComponentChanged event is called
      // a check is made that you're not already InDesignerChange,
      // or you'll end up removing the Binding you just set.
      public override void OnComponentChanged(object sender, ComponentChangedEventArgs ce)
		{
         if( webControl == null )
         	webControl = (Component as IDBWebDataLink);
			if(  !InDesignerChange && ce.Member != null && ce.Component != null && ce.Component == this.Component )
			{  // if event is called for this Component, then update its key properties
            // such as DBWebDataSource,
         	InDesignerChange = true;
            try
            {
	            FDBWebControlDesigner.UpdateWebControl(webControl,
   	         		Component.Site.Container.Components, ce, DataBindings);
      	   	OnBindingsCollectionChanged(ce.Member.Name);
            	if( webControl is DBWebCheckBox )
            			SetCheckBoxProperties(ce, webControl);
         	   UpdateDesignTimeHtml();
            }
            finally
            {
	            InDesignerChange = false;
            }
			}
         if( ce.Component == webControl )
         {
         	base.OnComponentChanged(sender, ce);
            if( webControl != null && webControl is DBWebNavigator && ce.Member != null && ce.Member.Name == "ButtonType" )
            	CheckForVirtualDirectory(webControl as DBWebNavigator);
         }
         else
         {
         	if( webControl != null )
            	CheckForUpdate(ce, webControl);
         }
      }

		public override string GetDesignTimeHtml()
		{
         webControl = Component as IDBWebDataLink;
      	FDBWebControlDesigner.SetProperties(DataBindings, webControl, Component.Site.Container.Components);
         return base.GetDesignTimeHtml();
      }

   }
   #endregion
   #region DBWebGridDesigner
   public class DBWebGridDesigner: System.Web.UI.Design.WebControls.DataGridDesigner
   {
   	protected event OnComponentChangedEvent OnUpdateComp;
		protected static bool InDesignerChange;
      protected IDBWebControlDesigner FDBWebControlDesigner;

   	private IDBWebDataLink webControl;
      protected IComponentChangeService componentChangeService;
      private ComponentEventHandler componentRemovedHandler;
      private ComponentChangedEventHandler componentChangedHandler;
   	public DBWebGridDesigner(): base()
      {
         FDBWebControlDesigner = new DBWebDesigner();
      }

      protected override void PreFilterProperties(System.Collections.IDictionary properties)
      {
      	base.PreFilterProperties(properties);
         FDBWebControlDesigner.PreFilterProperties(properties, Component as IDBWebDataLink);
         if( properties.Contains("Text") )
         	properties.Remove("Text");
      }

      public override void Initialize(IComponent component)
      {
         base.Initialize(component);
         componentChangeService = (IComponentChangeService)GetService(typeof(IComponentChangeService));
         webControl = (IDBWebDataLink) component;
         if ((componentChangeService != null))
	            {
                componentRemovedHandler = new System.ComponentModel.Design.ComponentEventHandler(OnComponentRemoving);
                componentChangeService.ComponentRemoved += componentRemovedHandler;
                componentChangedHandler = new System.ComponentModel.Design.ComponentChangedEventHandler(OnComponentChanged);
                componentChangeService.ComponentChanged += componentChangedHandler;
            }
         return;
      }

      protected override void Dispose(bool disposing)
      {
      	if (disposing && componentRemovedHandler != null && componentChangeService != null)
         {
         	componentChangeService.ComponentRemoved -= componentRemovedHandler;
            componentRemovedHandler = null;
            componentChangeService.ComponentChanged -= componentChangedHandler;
            componentChangedHandler = null;
            componentChangeService = null;
         }
         base.Dispose(disposing);
      }

		public override bool DesignTimeHtmlRequiresLoadComplete
		{
			get
			{
				return true;
			}
		}
      
      private void RemoveBindings(bool bSetDSNull)
      {
      	FDBWebControlDesigner.RemoveBindings(webControl, eRemoveBindingType.erbtAll);
      }

      private void OnComponentRemoving(object sender, ComponentEventArgs e)
      {
      	webControl = Component as IDBWebDataLink;
         FDBWebControlDesigner.OnComponentRemoving(webControl, e);
      }

      // Important that each time OnComponentChanged event is called
      // a check is made that you're not already InDesignerChange,
      // or you'll end up removing the Binding you just set.
      public override void OnComponentChanged(object sender, ComponentChangedEventArgs ce)
		{
         if( webControl == null )
         	webControl = (Component as IDBWebDataLink);
			if(  !InDesignerChange && ce.Component != null && ce.Component == this.Component )
			{  // if event is called for this Component, then update its key properties
            // such as DBWebDataSource,
         	InDesignerChange = true;
            try
            {
	            if( ce.Member != null )
   	         {
	   	         FDBWebControlDesigner.UpdateWebControl(webControl,
   	   	      		Component.Site.Container.Components, ce, DataBindings);
         			OnBindingsCollectionChanged(ce.Member.Name);
      	      	UpdateDesignTimeHtml();
                  if( ce.Member.Name == "DBDataSource" && webControl is DataGrid )
                  {
                  	if( ce.NewValue == null )
                     {
	                  	DBWebGrid grid = webControl as DBWebGrid;
   	                  grid.DataSource = ce.NewValue;
      	               DU.SetPropertyValue(grid, "DataSource", ce.NewValue );
                     }
                  }
      	      }
         		base.OnComponentChanged(sender, ce);
            }
            finally
            {
	            InDesignerChange = false;
            }
			}
         else
         {
         	if( webControl != null )
            {
               if( FDBWebControlDesigner.UpdateParentControl( webControl, ce ) )
               	UpdateDesignTimeHtml();
            }
         }
/*         if( ce.Component == webControl && ce.Member != null && ce.Member.Name == "DataSource" )
         {
         	if( webControl is DataGrid && !InDesignerChange)
            {
               InDesignerChange = true;
               try
               {
		            DataGrid grid = webControl as DataGrid;
   		      	DU.SetPropertyValue(grid, "DataSource", null );
               }
               finally
               {
	               InDesignerChange = false;
               }
            }
      	}*/
      }

		public override string GetDesignTimeHtml()
		{
         webControl = Component as IDBWebDataLink;
      	FDBWebControlDesigner.SetProperties(DataBindings, webControl, Component.Site.Container.Components);
         return base.GetDesignTimeHtml();
      }

   }
   #endregion

   #region DBWebCalendarDesigner
   public class DBWebCalendarDesigner: System.Web.UI.Design.WebControls.CalendarDesigner
   {
   	protected event OnComponentChangedEvent OnUpdateComp;
		protected static bool InDesignerChange;
      protected IDBWebControlDesigner FDBWebControlDesigner;

   	private IDBWebDataLink webControl;
      protected IComponentChangeService componentChangeService;
      private ComponentEventHandler componentRemovedHandler;
      private ComponentChangedEventHandler componentChangedHandler;
   	public DBWebCalendarDesigner(): base()
      {
         FDBWebControlDesigner = new DBWebDesigner();
      }

      protected override void PreFilterProperties(System.Collections.IDictionary properties)
      {
      	base.PreFilterProperties(properties);
         FDBWebControlDesigner.PreFilterProperties(properties, Component as IDBWebDataLink);
      	if( properties.Contains("DataSource") )
      		properties.Remove("DataSource");
         if( properties.Contains("Text") )
         	properties.Remove("Text");
      }

      public override void Initialize(IComponent component)
      {
         base.Initialize(component);
         componentChangeService = (IComponentChangeService)GetService(typeof(IComponentChangeService));
         webControl = (IDBWebDataLink) component;
         if ((componentChangeService != null))
	            {
                componentRemovedHandler = new System.ComponentModel.Design.ComponentEventHandler(OnComponentRemoving);
                componentChangeService.ComponentRemoved += componentRemovedHandler;
                componentChangedHandler = new System.ComponentModel.Design.ComponentChangedEventHandler(OnComponentChanged);
                componentChangeService.ComponentChanged += componentChangedHandler;
            }
         return;
      }

      protected override void Dispose(bool disposing)
      {
      	if (disposing && componentRemovedHandler != null && componentChangeService != null)
         {
         	componentChangeService.ComponentRemoved -= componentRemovedHandler;
            componentRemovedHandler = null;
            componentChangeService.ComponentChanged -= componentChangedHandler;
            componentChangedHandler = null;
            componentChangeService = null;
         }
         base.Dispose(disposing);
      }

		public override bool DesignTimeHtmlRequiresLoadComplete
		{
			get
			{
				return true;
			}
		}
      
      private void RemoveBindings(bool bSetDSNull)
      {
      	FDBWebControlDesigner.RemoveBindings(webControl, eRemoveBindingType.erbtAll);
      }

      private void OnComponentRemoving(object sender, ComponentEventArgs e)
      {
      	webControl = Component as IDBWebDataLink;
         FDBWebControlDesigner.OnComponentRemoving(webControl, e);
      }

      // Important that each time OnComponentChanged event is called
      // a check is made that you're not already InDesignerChange,
      // or you'll end up removing the Binding you just set.
      public override void OnComponentChanged(object sender, ComponentChangedEventArgs ce)
		{
         if( webControl == null )
         	webControl = (Component as IDBWebDataLink);
			if(  !InDesignerChange && ce.Component != null && ce.Component == this.Component )
			{  // if event is called for this Component, then update its key properties
            // such as DBWebDataSource,
         	InDesignerChange = true;
            try
            {
	            if( ce.Member != null )
   	         {
	   	         FDBWebControlDesigner.UpdateWebControl(webControl,
   	   	      		Component.Site.Container.Components, ce, DataBindings);
         			OnBindingsCollectionChanged(ce.Member.Name);
      	      	UpdateDesignTimeHtml();
      	      }
         		base.OnComponentChanged(sender, ce);
            }
            finally
            {
	            InDesignerChange = false;
            }
			}
         else
         {
         	if( webControl != null )
            {
               if( FDBWebControlDesigner.UpdateParentControl( webControl, ce ) )
               	UpdateDesignTimeHtml();
            }
         }
      }

		public override string GetDesignTimeHtml()
		{
         webControl = Component as IDBWebDataLink;
      	FDBWebControlDesigner.SetProperties(DataBindings, webControl, Component.Site.Container.Components);
         return base.GetDesignTimeHtml();
      }

   }
   #endregion


#endregion

}





